 ; FENSTER TFT-Textdisplay
.equ __30F4012, 1
.include "p30F4012.inc"
.include "ram.inc"
.include "allgdef.inc"

; Debug an EMUC1
config __FICD, PGD

; Oszillator auf intern 7,37MHz, PLL=16, /4 = 29,48MHz
config	__FOSC, FRC_PLL16

; Wachhund = aus
config	__FWDT, WDT_OFF

; ab 4,2V, 64ms
config	__FBORPOR, BORV42 & PWRT_64 

.global	__reset
.global __T1Interrupt
.global __AltU1RXInterrupt
.global __U1RXInterrupt
.global	__DefaultInterrupt

.text	

;-----------------------------------------------------	
__reset:

; stack setzen
 	mov 	#stackanfang,w15
	mov		#(stackanfang+160),w0
	mov 	W0,_SPLIM
; RAM lschen
	mov		#ramanfang,w0
 	repeat	#(ramende1-ramanfang)
 	clr		[w0++]
	nop
	mov		#0x0c00,w0
 	repeat	#276
 	clr		[w0++]
	nop
	
; Port B: b5 ... b0 Ausgnge
	MOV 	#0x00, W0
	MOV 	W0, TRISB
	nop
; Port C: b15,b13=Ausg, b14 = Eing
	mov		#0b0100000000000000, W0
	mov		w0,TRISC
	nop
; Port D: b0 = Ausg, b1= Eing
	mov		#0b010,W0
	mov		w0,TRISD
	nop
; Port E: b8,b5 ... b0 = Ausg
	mov		#0x000,w0
	mov		w0,TRISE
	nop
; Port F Debug RF2, RF3
    mov     #0,w0
    mov     w0,TRISF
    nop
	
; Daten aus EEPROM holen
;	call	Eepromlesen
	                    
; Timer 1 Interrupt alle 26,4us
	clr		T1CON
	clr		TMR1
	mov		#0x0010,w0 		; int Clk / 8 = 0,275us
	mov		w0,T1CON
	mov		#182,w0			; 182x0,275=50us
	mov		w0,PR1
	BCLR 	IFS0,#T1IF 
	bset 	IEC0,#T1IE
	bset	T1CON,#TON

; RS232 Init
	mov		#194,w0
	mov		w0,U1BRG		; 19200 Bd
	mov		#0b1000010000000000,w0
	mov		w0,U1MODE
	mov		#0x0400,w0
	mov		w0,U1STA
	bclr	IFS0,#U1RXIF	; muss beim ersten mal gelscht sein
	bset	IEC0,#U1RXIE	; Rx Int erlauben
	mov		#rs232cpuffer,w0
	mov		w0,rspufferzgr1
	mov		w0,rspufferzgr2
	
; PSV aktivieren
	bset	CORCON,#PSV
	mov		#psvpage(psvanfang),w0
	mov		w0,PSVPAG
	
; TFT
	call	Lcdinit
    mov     #1,w0
    mov     w0,schriftgroesse

; Hauptschleife
hp:	
	call	RS232control	; RS232
	nop
	nop
	nop
	Call	Lcdbed			; Sendet zum TFT
	nop
	nop
	nop
	goto	hp
		
;---------------------------------------------------
; Interrupt wird alle 50us aktiv
; Register W14 nur fr diese Int-Routine reserviert

__T1Interrupt:
	BCLR 	IFS0,#T1IF ; Reset Timer1 interrupt flag
	dec		w14,w14
	bra		z,t1inta
	retfie
t1inta:
	mov		#200,w14		; 200 x 50us = 10ms
    cp0     rs232ctimer
    bra     z,t1intb
	dec		rs232ctimer
t1intb:
	retfie

; ----------------------------------------------------
; Interrupt fr RS232 - Empfnger
; ----------------------------------------------------
__AltU1RXInterrupt:
__U1RXInterrupt:
	push	w0
	push	w1
	bclr	IFS0,#U1RXIF
	mov		rspufferzgr1,w1
	mov		U1RXREG,w0
	mov.b	w0,[w1++]
	btsc	w1,#9
	mov		#rs232cpuffer,w1
altu1a:
	mov		w1,rspufferzgr1
	pop		w1
	pop		w0
	retfie
	
__DefaultInterrupt:
	nop
	nop
	retfie

 